/**
    \file DeadReckoning.h
    Header file for DeadReckoning distance transform class which, given
    and input binary image, calculates the corresponding distance transform
    via various methods.

    \author George J. Grevera, Ph.D., ggrevera@sju.edu

    Copyright (C) 2002, George J. Grevera

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA or from http://www.gnu.org/licenses/gpl.txt.

    This General Public License does not permit incorporating this
    code into proprietary programs.  (So a hypothetical company such
    as GH (Generally Hectic) should NOT incorporate this code into
    their proprietary programs.)
*/
#ifndef DeadReckoning_h
#define DeadReckoning_h

#include "DistanceTransform.h"
#include <iostream>
using namespace std;
//----------------------------------------------------------------------
/// Abstract base class for Dead Reckoning distance transform algorithms.
class DeadReckoning : public DistanceTransform {

public:
    DeadReckoning ( const int xSize, const int ySize, const bool unload=true )
        : DistanceTransform(xSize, ySize, unload)
    {
    }

    /// return the "parent" (border point) associated with this point
    /**
     * @param x is the x location
     * @param y is the y location
     * @param px is the parent's x location to be returned
     * @param py is the parent's y location to be returned
     * @return true if the parent is know; otherwise false.
     */
    virtual inline bool getP ( const int x, const int y, int& px, int& py ) const {
        if (p==NULL)    return false;
        const int s = sub(x,y);
        px = p[s].x;
        py = p[s].y;
        return true;
    }

protected:
    P *p;
};

#endif
//----------------------------------------------------------------------

